package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfacePermissionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInterfacePermissionRequest(
    networkInterfacePermissionId: NetworkInterfacePermissionId,
    force: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest = {
    import DeleteNetworkInterfacePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest
      .builder()
      .networkInterfacePermissionId(
        NetworkInterfacePermissionId.unwrap(
          networkInterfacePermissionId
        ): java.lang.String
      )
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest
      .wrap(buildAwsValue())
}
object DeleteNetworkInterfacePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest =
      zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest(
        networkInterfacePermissionId,
        force.map(value => value),
        dryRun.map(value => value)
      )
    def networkInterfacePermissionId: NetworkInterfacePermissionId
    def force: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def getNetworkInterfacePermissionId
        : ZIO[Any, Nothing, NetworkInterfacePermissionId] =
      ZIO.succeed(networkInterfacePermissionId)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest.ReadOnly {
    override val networkInterfacePermissionId: NetworkInterfacePermissionId =
      zio.aws.ec2.model.primitives
        .NetworkInterfacePermissionId(impl.networkInterfacePermissionId())
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest
  ): zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
