package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAnalysisRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    networkInsightsAnalysisId: NetworkInsightsAnalysisId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest = {
    import DeleteNetworkInsightsAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .networkInsightsAnalysisId(
        NetworkInsightsAnalysisId.unwrap(
          networkInsightsAnalysisId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.wrap(buildAwsValue())
}
object DeleteNetworkInsightsAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest =
      zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest(
        dryRun.map(value => value),
        networkInsightsAnalysisId
      )
    def dryRun: Optional[Boolean]
    def networkInsightsAnalysisId: NetworkInsightsAnalysisId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNetworkInsightsAnalysisId
        : ZIO[Any, Nothing, NetworkInsightsAnalysisId] =
      ZIO.succeed(networkInsightsAnalysisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val networkInsightsAnalysisId: NetworkInsightsAnalysisId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsAnalysisId(impl.networkInsightsAnalysisId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ): zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
