package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAccessScopeRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    networkInsightsAccessScopeId: NetworkInsightsAccessScopeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest = {
    import DeleteNetworkInsightsAccessScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .networkInsightsAccessScopeId(
        NetworkInsightsAccessScopeId.unwrap(
          networkInsightsAccessScopeId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest
      .wrap(buildAwsValue())
}
object DeleteNetworkInsightsAccessScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest =
      zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest(
        dryRun.map(value => value),
        networkInsightsAccessScopeId
      )
    def dryRun: Optional[Boolean]
    def networkInsightsAccessScopeId: NetworkInsightsAccessScopeId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, Nothing, NetworkInsightsAccessScopeId] =
      ZIO.succeed(networkInsightsAccessScopeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val networkInsightsAccessScopeId: NetworkInsightsAccessScopeId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsAccessScopeId(impl.networkInsightsAccessScopeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest
  ): zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest.ReadOnly =
    new Wrapper(impl)
}
