package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, NetworkAclId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkAclEntryRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    egress: Boolean,
    networkAclId: NetworkAclId,
    ruleNumber: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest = {
    import DeleteNetworkAclEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .egress(egress: java.lang.Boolean)
      .networkAclId(NetworkAclId.unwrap(networkAclId): java.lang.String)
      .ruleNumber(ruleNumber: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNetworkAclEntryRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkAclEntryRequest.wrap(buildAwsValue())
}
object DeleteNetworkAclEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkAclEntryRequest =
      zio.aws.ec2.model.DeleteNetworkAclEntryRequest(
        dryRun.map(value => value),
        egress,
        networkAclId,
        ruleNumber
      )
    def dryRun: Optional[Boolean]
    def egress: Boolean
    def networkAclId: NetworkAclId
    def ruleNumber: Integer
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEgress: ZIO[Any, Nothing, Boolean] = ZIO.succeed(egress)
    def getNetworkAclId: ZIO[Any, Nothing, NetworkAclId] =
      ZIO.succeed(networkAclId)
    def getRuleNumber: ZIO[Any, Nothing, Integer] = ZIO.succeed(ruleNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest
  ) extends zio.aws.ec2.model.DeleteNetworkAclEntryRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val egress: Boolean = impl.egress(): Boolean
    override val networkAclId: NetworkAclId =
      zio.aws.ec2.model.primitives.NetworkAclId(impl.networkAclId())
    override val ruleNumber: Integer = impl.ruleNumber(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest
  ): zio.aws.ec2.model.DeleteNetworkAclEntryRequest.ReadOnly = new Wrapper(impl)
}
