package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(
    localGatewayRouteTableVirtualInterfaceGroupAssociationId: LocalGatewayRouteTableVirtualInterfaceGroupAssociationId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest = {
    import DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
      .builder()
      .localGatewayRouteTableVirtualInterfaceGroupAssociationId(
        LocalGatewayRouteTableVirtualInterfaceGroupAssociationId.unwrap(
          localGatewayRouteTableVirtualInterfaceGroupAssociationId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest =
      zio.aws.ec2.model
        .DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(
          localGatewayRouteTableVirtualInterfaceGroupAssociationId,
          dryRun.map(value => value)
        )
    def localGatewayRouteTableVirtualInterfaceGroupAssociationId
        : LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
    def dryRun: Optional[Boolean]
    def getLocalGatewayRouteTableVirtualInterfaceGroupAssociationId: ZIO[
      Any,
      Nothing,
      LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
    ] = ZIO.succeed(localGatewayRouteTableVirtualInterfaceGroupAssociationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.ReadOnly {
    override val localGatewayRouteTableVirtualInterfaceGroupAssociationId
        : LocalGatewayRouteTableVirtualInterfaceGroupAssociationId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRouteTableVirtualInterfaceGroupAssociationId(
          impl.localGatewayRouteTableVirtualInterfaceGroupAssociationId()
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
