package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayRoutetableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteTableRequest(
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest = {
    import DeleteLocalGatewayRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
      .builder()
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest =
      zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest(
        localGatewayRouteTableId,
        dryRun.map(value => value)
      )
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def dryRun: Optional[Boolean]
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.ReadOnly {
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.ReadOnly =
    new Wrapper(impl)
}
