package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamResourceDiscoveryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteIpamResourceDiscoveryRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamResourceDiscoveryId: IpamResourceDiscoveryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest = {
    import DeleteIpamResourceDiscoveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamResourceDiscoveryId(
        IpamResourceDiscoveryId.unwrap(
          ipamResourceDiscoveryId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.wrap(buildAwsValue())
}
object DeleteIpamResourceDiscoveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest =
      zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest(
        dryRun.map(value => value),
        ipamResourceDiscoveryId
      )
    def dryRun: Optional[Boolean]
    def ipamResourceDiscoveryId: IpamResourceDiscoveryId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamResourceDiscoveryId: ZIO[Any, Nothing, IpamResourceDiscoveryId] =
      ZIO.succeed(ipamResourceDiscoveryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
  ) extends zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamResourceDiscoveryId: IpamResourceDiscoveryId =
      zio.aws.ec2.model.primitives
        .IpamResourceDiscoveryId(impl.ipamResourceDiscoveryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
  ): zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.ReadOnly =
    new Wrapper(impl)
}
