package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolCoipId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCoipPoolRequest(
    coipPoolId: Ipv4PoolCoipId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest = {
    import DeleteCoipPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
      .builder()
      .coipPoolId(Ipv4PoolCoipId.unwrap(coipPoolId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCoipPoolRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCoipPoolRequest.wrap(buildAwsValue())
}
object DeleteCoipPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCoipPoolRequest = zio.aws.ec2.model
      .DeleteCoipPoolRequest(coipPoolId, dryRun.map(value => value))
    def coipPoolId: Ipv4PoolCoipId
    def dryRun: Optional[Boolean]
    def getCoipPoolId: ZIO[Any, Nothing, Ipv4PoolCoipId] =
      ZIO.succeed(coipPoolId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
  ) extends zio.aws.ec2.model.DeleteCoipPoolRequest.ReadOnly {
    override val coipPoolId: Ipv4PoolCoipId =
      zio.aws.ec2.model.primitives.Ipv4PoolCoipId(impl.coipPoolId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
  ): zio.aws.ec2.model.DeleteCoipPoolRequest.ReadOnly = new Wrapper(impl)
}
