package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DatafeedSubscriptionState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState
}
object DatafeedSubscriptionState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState
  ): zio.aws.ec2.model.DatafeedSubscriptionState = value match {
    case software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DatafeedSubscriptionState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState =
      software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.ec2.model.DatafeedSubscriptionState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState =
      software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState.ACTIVE
  }
  case object Inactive extends zio.aws.ec2.model.DatafeedSubscriptionState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState =
      software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState.INACTIVE
  }
}
