package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessGroupResponse(
    verifiedAccessGroup: Optional[zio.aws.ec2.model.VerifiedAccessGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse = {
    import CreateVerifiedAccessGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse
      .builder()
      .optionallyWith(verifiedAccessGroup.map(value => value.buildAwsValue()))(
        _.verifiedAccessGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVerifiedAccessGroupResponse.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessGroupResponse.wrap(buildAwsValue())
}
object CreateVerifiedAccessGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessGroupResponse =
      zio.aws.ec2.model.CreateVerifiedAccessGroupResponse(
        verifiedAccessGroup.map(value => value.asEditable)
      )
    def verifiedAccessGroup
        : Optional[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly]
    def getVerifiedAccessGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly] =
      AwsError.unwrapOptionField("verifiedAccessGroup", verifiedAccessGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse
  ) extends zio.aws.ec2.model.CreateVerifiedAccessGroupResponse.ReadOnly {
    override val verifiedAccessGroup
        : Optional[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroup())
        .map(value => zio.aws.ec2.model.VerifiedAccessGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse
  ): zio.aws.ec2.model.CreateVerifiedAccessGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
