package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayMulticastDomainRequest(
    transitGatewayId: TransitGatewayId,
    options: Optional[
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest = {
    import CreateTransitGatewayMulticastDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayMulticastDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest =
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest(
        transitGatewayId,
        options.map(value => value.asEditable),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def transitGatewayId: TransitGatewayId
    def options: Optional[
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly
    ]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val options: Optional[
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
          .wrap(value)
      )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ): zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest.ReadOnly =
    new Wrapper(impl)
}
