package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcEndpointId, NetworkInterfaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorTargetRequest(
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    networkLoadBalancerArn: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    gatewayLoadBalancerEndpointId: Optional[VpcEndpointId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest = {
    import CreateTrafficMirrorTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        networkLoadBalancerArn.map(value => value: java.lang.String)
      )(_.networkLoadBalancerArn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        gatewayLoadBalancerEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.gatewayLoadBalancerEndpointId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.wrap(buildAwsValue())
}
object CreateTrafficMirrorTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest =
      zio.aws.ec2.model.CreateTrafficMirrorTargetRequest(
        networkInterfaceId.map(value => value),
        networkLoadBalancerArn.map(value => value),
        description.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        clientToken.map(value => value),
        gatewayLoadBalancerEndpointId.map(value => value)
      )
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def networkLoadBalancerArn: Optional[String]
    def description: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def gatewayLoadBalancerEndpointId: Optional[VpcEndpointId]
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkLoadBalancerArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("networkLoadBalancerArn", networkLoadBalancerArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getGatewayLoadBalancerEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField(
        "gatewayLoadBalancerEndpointId",
        gatewayLoadBalancerEndpointId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
  ) extends zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.ReadOnly {
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val networkLoadBalancerArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkLoadBalancerArn())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val gatewayLoadBalancerEndpointId: Optional[VpcEndpointId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayLoadBalancerEndpointId())
        .map(value => zio.aws.ec2.model.primitives.VpcEndpointId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
  ): zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
