package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSubnetCidrReservationResponse(
    subnetCidrReservation: Optional[zio.aws.ec2.model.SubnetCidrReservation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse = {
    import CreateSubnetCidrReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse
      .builder()
      .optionallyWith(
        subnetCidrReservation.map(value => value.buildAwsValue())
      )(_.subnetCidrReservation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly =
    zio.aws.ec2.model.CreateSubnetCidrReservationResponse.wrap(buildAwsValue())
}
object CreateSubnetCidrReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSubnetCidrReservationResponse =
      zio.aws.ec2.model.CreateSubnetCidrReservationResponse(
        subnetCidrReservation.map(value => value.asEditable)
      )
    def subnetCidrReservation
        : Optional[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly]
    def getSubnetCidrReservation
        : ZIO[Any, AwsError, zio.aws.ec2.model.SubnetCidrReservation.ReadOnly] =
      AwsError.unwrapOptionField("subnetCidrReservation", subnetCidrReservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse
  ) extends zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly {
    override val subnetCidrReservation
        : Optional[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetCidrReservation())
        .map(value => zio.aws.ec2.model.SubnetCidrReservation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse
  ): zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly =
    new Wrapper(impl)
}
