package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteTableRequest(
    localGatewayId: LocalGatewayId,
    mode: Optional[zio.aws.ec2.model.LocalGatewayRouteTableMode] =
      Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest = {
    import CreateLocalGatewayRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest
      .builder()
      .localGatewayId(LocalGatewayId.unwrap(localGatewayId): java.lang.String)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLocalGatewayRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteTableRequest.wrap(buildAwsValue())
}
object CreateLocalGatewayRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLocalGatewayRouteTableRequest =
      zio.aws.ec2.model.CreateLocalGatewayRouteTableRequest(
        localGatewayId,
        mode.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def localGatewayId: LocalGatewayId
    def mode: Optional[zio.aws.ec2.model.LocalGatewayRouteTableMode]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getLocalGatewayId: ZIO[Any, Nothing, LocalGatewayId] =
      ZIO.succeed(localGatewayId)
    def getMode
        : ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteTableMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteTableRequest.ReadOnly {
    override val localGatewayId: LocalGatewayId =
      zio.aws.ec2.model.primitives.LocalGatewayId(impl.localGatewayId())
    override val mode: Optional[zio.aws.ec2.model.LocalGatewayRouteTableMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.ec2.model.LocalGatewayRouteTableMode.wrap(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest
  ): zio.aws.ec2.model.CreateLocalGatewayRouteTableRequest.ReadOnly =
    new Wrapper(impl)
}
