package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInstanceConnectEndpointResponse(
    instanceConnectEndpoint: Optional[
      zio.aws.ec2.model.Ec2InstanceConnectEndpoint
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse = {
    import CreateInstanceConnectEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse
      .builder()
      .optionallyWith(
        instanceConnectEndpoint.map(value => value.buildAwsValue())
      )(_.instanceConnectEndpoint)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateInstanceConnectEndpointResponse.ReadOnly =
    zio.aws.ec2.model.CreateInstanceConnectEndpointResponse
      .wrap(buildAwsValue())
}
object CreateInstanceConnectEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInstanceConnectEndpointResponse =
      zio.aws.ec2.model.CreateInstanceConnectEndpointResponse(
        instanceConnectEndpoint.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def instanceConnectEndpoint
        : Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly]
    def clientToken: Optional[String]
    def getInstanceConnectEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceConnectEndpoint",
      instanceConnectEndpoint
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse
  ) extends zio.aws.ec2.model.CreateInstanceConnectEndpointResponse.ReadOnly {
    override val instanceConnectEndpoint
        : Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConnectEndpoint())
        .map(value => zio.aws.ec2.model.Ec2InstanceConnectEndpoint.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse
  ): zio.aws.ec2.model.CreateInstanceConnectEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
