package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelCapacityReservationRequest(
    capacityReservationId: CapacityReservationId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest = {
    import CancelCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
      .builder()
      .capacityReservationId(
        CapacityReservationId.unwrap(capacityReservationId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.CancelCapacityReservationRequest.wrap(buildAwsValue())
}
object CancelCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelCapacityReservationRequest =
      zio.aws.ec2.model.CancelCapacityReservationRequest(
        capacityReservationId,
        dryRun.map(value => value)
      )
    def capacityReservationId: CapacityReservationId
    def dryRun: Optional[Boolean]
    def getCapacityReservationId: ZIO[Any, Nothing, CapacityReservationId] =
      ZIO.succeed(capacityReservationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
  ) extends zio.aws.ec2.model.CancelCapacityReservationRequest.ReadOnly {
    override val capacityReservationId: CapacityReservationId =
      zio.aws.ec2.model.primitives
        .CapacityReservationId(impl.capacityReservationId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
  ): zio.aws.ec2.model.CancelCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
