package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthorizeClientVpnIngressRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    targetNetworkCidr: String,
    accessGroupId: Optional[String] = Optional.Absent,
    authorizeAllGroups: Optional[Boolean] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest = {
    import AuthorizeClientVpnIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .targetNetworkCidr(targetNetworkCidr: java.lang.String)
      .optionallyWith(accessGroupId.map(value => value: java.lang.String))(
        _.accessGroupId
      )
      .optionallyWith(
        authorizeAllGroups.map(value => value: java.lang.Boolean)
      )(_.authorizeAllGroups)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.ReadOnly =
    zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.wrap(buildAwsValue())
}
object AuthorizeClientVpnIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest =
      zio.aws.ec2.model.AuthorizeClientVpnIngressRequest(
        clientVpnEndpointId,
        targetNetworkCidr,
        accessGroupId.map(value => value),
        authorizeAllGroups.map(value => value),
        description.map(value => value),
        clientToken.map(value => value),
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def targetNetworkCidr: String
    def accessGroupId: Optional[String]
    def authorizeAllGroups: Optional[Boolean]
    def description: Optional[String]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getTargetNetworkCidr: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetNetworkCidr)
    def getAccessGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessGroupId", accessGroupId)
    def getAuthorizeAllGroups: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("authorizeAllGroups", authorizeAllGroups)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
  ) extends zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val targetNetworkCidr: String = impl.targetNetworkCidr(): String
    override val accessGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessGroupId())
      .map(value => value: String)
    override val authorizeAllGroups: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizeAllGroups())
      .map(value => value: Boolean)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
  ): zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.ReadOnly = new Wrapper(
    impl
  )
}
