package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  TransitGatewayAttachmentId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayMulticastDomainRequest(
    transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    subnetIds: Iterable[SubnetId],
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest = {
    import AssociateTransitGatewayMulticastDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
      .builder()
      .transitGatewayMulticastDomainId(
        TransitGatewayMulticastDomainId.unwrap(
          transitGatewayMulticastDomainId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest.ReadOnly =
    zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayMulticastDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest =
      zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest(
        transitGatewayMulticastDomainId,
        transitGatewayAttachmentId,
        subnetIds,
        dryRun.map(value => value)
      )
    def transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def subnetIds: List[SubnetId]
    def dryRun: Optional[Boolean]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, Nothing, TransitGatewayMulticastDomainId] =
      ZIO.succeed(transitGatewayMulticastDomainId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ) extends zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : TransitGatewayMulticastDomainId = zio.aws.ec2.model.primitives
      .TransitGatewayMulticastDomainId(impl.transitGatewayMulticastDomainId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SubnetId(item)
      }
      .toList
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ): zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest.ReadOnly =
    new Wrapper(impl)
}
