package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NatGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssignPrivateNatGatewayAddressResponse(
    natGatewayId: Optional[NatGatewayId] = Optional.Absent,
    natGatewayAddresses: Optional[
      Iterable[zio.aws.ec2.model.NatGatewayAddress]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse = {
    import AssignPrivateNatGatewayAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse
      .builder()
      .optionallyWith(
        natGatewayId.map(value => NatGatewayId.unwrap(value): java.lang.String)
      )(_.natGatewayId)
      .optionallyWith(
        natGatewayAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.natGatewayAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssignPrivateNatGatewayAddressResponse.ReadOnly =
    zio.aws.ec2.model.AssignPrivateNatGatewayAddressResponse
      .wrap(buildAwsValue())
}
object AssignPrivateNatGatewayAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignPrivateNatGatewayAddressResponse =
      zio.aws.ec2.model.AssignPrivateNatGatewayAddressResponse(
        natGatewayId.map(value => value),
        natGatewayAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def natGatewayId: Optional[NatGatewayId]
    def natGatewayAddresses
        : Optional[List[zio.aws.ec2.model.NatGatewayAddress.ReadOnly]]
    def getNatGatewayId: ZIO[Any, AwsError, NatGatewayId] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getNatGatewayAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NatGatewayAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("natGatewayAddresses", natGatewayAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse
  ) extends zio.aws.ec2.model.AssignPrivateNatGatewayAddressResponse.ReadOnly {
    override val natGatewayId: Optional[NatGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => zio.aws.ec2.model.primitives.NatGatewayId(value))
    override val natGatewayAddresses
        : Optional[List[zio.aws.ec2.model.NatGatewayAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.natGatewayAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NatGatewayAddress.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse
  ): zio.aws.ec2.model.AssignPrivateNatGatewayAddressResponse.ReadOnly =
    new Wrapper(impl)
}
