package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdditionalDetail(
    additionalDetailType: Optional[String] = Optional.Absent,
    component: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    vpcEndpointService: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    ruleOptions: Optional[Iterable[zio.aws.ec2.model.RuleOption]] =
      Optional.Absent,
    ruleGroupTypePairs: Optional[
      Iterable[zio.aws.ec2.model.RuleGroupTypePair]
    ] = Optional.Absent,
    ruleGroupRuleOptionsPairs: Optional[
      Iterable[zio.aws.ec2.model.RuleGroupRuleOptionsPair]
    ] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    loadBalancers: Optional[Iterable[zio.aws.ec2.model.AnalysisComponent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AdditionalDetail = {
    import AdditionalDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AdditionalDetail
      .builder()
      .optionallyWith(
        additionalDetailType.map(value => value: java.lang.String)
      )(_.additionalDetailType)
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(vpcEndpointService.map(value => value.buildAwsValue()))(
        _.vpcEndpointService
      )
      .optionallyWith(
        ruleOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleOptions)
      .optionallyWith(
        ruleGroupTypePairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroupTypePairs)
      .optionallyWith(
        ruleGroupRuleOptionsPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroupRuleOptionsPairs)
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AdditionalDetail.ReadOnly =
    zio.aws.ec2.model.AdditionalDetail.wrap(buildAwsValue())
}
object AdditionalDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AdditionalDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AdditionalDetail =
      zio.aws.ec2.model.AdditionalDetail(
        additionalDetailType.map(value => value),
        component.map(value => value.asEditable),
        vpcEndpointService.map(value => value.asEditable),
        ruleOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ruleGroupTypePairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ruleGroupRuleOptionsPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceName.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def additionalDetailType: Optional[String]
    def component: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpcEndpointService
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def ruleOptions: Optional[List[zio.aws.ec2.model.RuleOption.ReadOnly]]
    def ruleGroupTypePairs
        : Optional[List[zio.aws.ec2.model.RuleGroupTypePair.ReadOnly]]
    def ruleGroupRuleOptionsPairs
        : Optional[List[zio.aws.ec2.model.RuleGroupRuleOptionsPair.ReadOnly]]
    def serviceName: Optional[String]
    def loadBalancers
        : Optional[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]]
    def getAdditionalDetailType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalDetailType", additionalDetailType)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getVpcEndpointService
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpointService", vpcEndpointService)
    def getRuleOptions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RuleOption.ReadOnly]] =
      AwsError.unwrapOptionField("ruleOptions", ruleOptions)
    def getRuleGroupTypePairs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RuleGroupTypePair.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroupTypePairs", ruleGroupTypePairs)
    def getRuleGroupRuleOptionsPairs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RuleGroupRuleOptionsPair.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ruleGroupRuleOptionsPairs",
      ruleGroupRuleOptionsPairs
    )
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AnalysisComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AdditionalDetail
  ) extends zio.aws.ec2.model.AdditionalDetail.ReadOnly {
    override val additionalDetailType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalDetailType())
      .map(value => value: String)
    override val component
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpcEndpointService
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointService())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val ruleOptions
        : Optional[List[zio.aws.ec2.model.RuleOption.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RuleOption.wrap(item)
          }.toList
        )
    override val ruleGroupTypePairs
        : Optional[List[zio.aws.ec2.model.RuleGroupTypePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroupTypePairs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RuleGroupTypePair.wrap(item)
          }.toList
        )
    override val ruleGroupRuleOptionsPairs
        : Optional[List[zio.aws.ec2.model.RuleGroupRuleOptionsPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroupRuleOptionsPairs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RuleGroupRuleOptionsPair.wrap(item)
          }.toList
        )
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val loadBalancers
        : Optional[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AnalysisComponent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AdditionalDetail
  ): zio.aws.ec2.model.AdditionalDetail.ReadOnly = new Wrapper(impl)
}
