package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessInstance(
    verifiedAccessInstanceId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    verifiedAccessTrustProviders: Optional[
      Iterable[zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed]
    ] = Optional.Absent,
    creationTime: Optional[String] = Optional.Absent,
    lastUpdatedTime: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    fipsEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance = {
    import VerifiedAccessInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance
      .builder()
      .optionallyWith(
        verifiedAccessInstanceId.map(value => value: java.lang.String)
      )(_.verifiedAccessInstanceId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        verifiedAccessTrustProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verifiedAccessTrustProviders)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(lastUpdatedTime.map(value => value: java.lang.String))(
        _.lastUpdatedTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(fipsEnabled.map(value => value: java.lang.Boolean))(
        _.fipsEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessInstance.wrap(buildAwsValue())
}
object VerifiedAccessInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessInstance =
      zio.aws.ec2.model.VerifiedAccessInstance(
        verifiedAccessInstanceId.map(value => value),
        description.map(value => value),
        verifiedAccessTrustProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fipsEnabled.map(value => value)
      )
    def verifiedAccessInstanceId: Optional[String]
    def description: Optional[String]
    def verifiedAccessTrustProviders: Optional[
      List[zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.ReadOnly]
    ]
    def creationTime: Optional[String]
    def lastUpdatedTime: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def fipsEnabled: Optional[Boolean]
    def getVerifiedAccessInstanceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVerifiedAccessTrustProviders: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "verifiedAccessTrustProviders",
      verifiedAccessTrustProviders
    )
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFipsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("fipsEnabled", fipsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance
  ) extends zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly {
    override val verifiedAccessInstanceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val verifiedAccessTrustProviders: Optional[
      List[zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessTrustProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.wrap(item)
        }.toList
      )
    override val creationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: String)
    override val lastUpdatedTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val fipsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.fipsEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance
  ): zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly = new Wrapper(impl)
}
