package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessEndpoint(
    verifiedAccessInstanceId: Optional[String] = Optional.Absent,
    verifiedAccessGroupId: Optional[String] = Optional.Absent,
    verifiedAccessEndpointId: Optional[String] = Optional.Absent,
    applicationDomain: Optional[String] = Optional.Absent,
    endpointType: Optional[zio.aws.ec2.model.VerifiedAccessEndpointType] =
      Optional.Absent,
    attachmentType: Optional[
      zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType
    ] = Optional.Absent,
    domainCertificateArn: Optional[String] = Optional.Absent,
    endpointDomain: Optional[String] = Optional.Absent,
    deviceValidationDomain: Optional[String] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    loadBalancerOptions: Optional[
      zio.aws.ec2.model.VerifiedAccessEndpointLoadBalancerOptions
    ] = Optional.Absent,
    networkInterfaceOptions: Optional[
      zio.aws.ec2.model.VerifiedAccessEndpointEniOptions
    ] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.VerifiedAccessEndpointStatus] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    creationTime: Optional[String] = Optional.Absent,
    lastUpdatedTime: Optional[String] = Optional.Absent,
    deletionTime: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint = {
    import VerifiedAccessEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint
      .builder()
      .optionallyWith(
        verifiedAccessInstanceId.map(value => value: java.lang.String)
      )(_.verifiedAccessInstanceId)
      .optionallyWith(
        verifiedAccessGroupId.map(value => value: java.lang.String)
      )(_.verifiedAccessGroupId)
      .optionallyWith(
        verifiedAccessEndpointId.map(value => value: java.lang.String)
      )(_.verifiedAccessEndpointId)
      .optionallyWith(applicationDomain.map(value => value: java.lang.String))(
        _.applicationDomain
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(
        domainCertificateArn.map(value => value: java.lang.String)
      )(_.domainCertificateArn)
      .optionallyWith(endpointDomain.map(value => value: java.lang.String))(
        _.endpointDomain
      )
      .optionallyWith(
        deviceValidationDomain.map(value => value: java.lang.String)
      )(_.deviceValidationDomain)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(loadBalancerOptions.map(value => value.buildAwsValue()))(
        _.loadBalancerOptions
      )
      .optionallyWith(
        networkInterfaceOptions.map(value => value.buildAwsValue())
      )(_.networkInterfaceOptions)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(lastUpdatedTime.map(value => value: java.lang.String))(
        _.lastUpdatedTime
      )
      .optionallyWith(deletionTime.map(value => value: java.lang.String))(
        _.deletionTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessEndpoint.wrap(buildAwsValue())
}
object VerifiedAccessEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessEndpoint =
      zio.aws.ec2.model.VerifiedAccessEndpoint(
        verifiedAccessInstanceId.map(value => value),
        verifiedAccessGroupId.map(value => value),
        verifiedAccessEndpointId.map(value => value),
        applicationDomain.map(value => value),
        endpointType.map(value => value),
        attachmentType.map(value => value),
        domainCertificateArn.map(value => value),
        endpointDomain.map(value => value),
        deviceValidationDomain.map(value => value),
        securityGroupIds.map(value => value),
        loadBalancerOptions.map(value => value.asEditable),
        networkInterfaceOptions.map(value => value.asEditable),
        status.map(value => value.asEditable),
        description.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        deletionTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessInstanceId: Optional[String]
    def verifiedAccessGroupId: Optional[String]
    def verifiedAccessEndpointId: Optional[String]
    def applicationDomain: Optional[String]
    def endpointType: Optional[zio.aws.ec2.model.VerifiedAccessEndpointType]
    def attachmentType
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType]
    def domainCertificateArn: Optional[String]
    def endpointDomain: Optional[String]
    def deviceValidationDomain: Optional[String]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def loadBalancerOptions: Optional[
      zio.aws.ec2.model.VerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ]
    def networkInterfaceOptions
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointEniOptions.ReadOnly]
    def status
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointStatus.ReadOnly]
    def description: Optional[String]
    def creationTime: Optional[String]
    def lastUpdatedTime: Optional[String]
    def deletionTime: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ]
    def getVerifiedAccessInstanceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getVerifiedAccessGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("verifiedAccessGroupId", verifiedAccessGroupId)
    def getVerifiedAccessEndpointId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("verifiedAccessEndpointId", verifiedAccessEndpointId)
    def getApplicationDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applicationDomain", applicationDomain)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessEndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getAttachmentType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType
    ] = AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getDomainCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainCertificateArn", domainCertificateArn)
    def getEndpointDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointDomain", endpointDomain)
    def getDeviceValidationDomain: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deviceValidationDomain", deviceValidationDomain)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getLoadBalancerOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerOptions", loadBalancerOptions)
    def getNetworkInterfaceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessEndpointEniOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInterfaceOptions",
      networkInterfaceOptions
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessEndpointStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getDeletionTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint
  ) extends zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly {
    override val verifiedAccessInstanceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value => value: String)
    override val verifiedAccessGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessGroupId())
      .map(value => value: String)
    override val verifiedAccessEndpointId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessEndpointId())
        .map(value => value: String)
    override val applicationDomain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationDomain())
      .map(value => value: String)
    override val endpointType
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.ec2.model.VerifiedAccessEndpointType.wrap(value))
    override val attachmentType
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentType())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType.wrap(value)
        )
    override val domainCertificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainCertificateArn())
      .map(value => value: String)
    override val endpointDomain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointDomain())
      .map(value => value: String)
    override val deviceValidationDomain: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceValidationDomain())
        .map(value => value: String)
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val loadBalancerOptions: Optional[
      zio.aws.ec2.model.VerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerOptions())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessEndpointLoadBalancerOptions.wrap(value)
      )
    override val networkInterfaceOptions: Optional[
      zio.aws.ec2.model.VerifiedAccessEndpointEniOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceOptions())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessEndpointEniOptions.wrap(value)
      )
    override val status
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessEndpointStatus.wrap(value)
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val creationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: String)
    override val lastUpdatedTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => value: String)
    override val deletionTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionTime())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint
  ): zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly = new Wrapper(impl)
}
