package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SecurityGroupName, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityGroupRuleDescriptionsIngressRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    groupId: Optional[SecurityGroupId] = Optional.Absent,
    groupName: Optional[SecurityGroupName] = Optional.Absent,
    ipPermissions: Optional[Iterable[zio.aws.ec2.model.IpPermission]] =
      Optional.Absent,
    securityGroupRuleDescriptions: Optional[
      Iterable[zio.aws.ec2.model.SecurityGroupRuleDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest = {
    import UpdateSecurityGroupRuleDescriptionsIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(
        securityGroupRuleDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupRuleDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest.ReadOnly =
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
      .wrap(buildAwsValue())
}
object UpdateSecurityGroupRuleDescriptionsIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest =
      zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest(
        dryRun.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupRuleDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[Boolean]
    def groupId: Optional[SecurityGroupId]
    def groupName: Optional[SecurityGroupName]
    def ipPermissions: Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def securityGroupRuleDescriptions: Optional[
      List[zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly]
    ]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getSecurityGroupRuleDescriptions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityGroupRuleDescriptions",
      securityGroupRuleDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
  ) extends zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val groupId: Optional[SecurityGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupName: Optional[SecurityGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupName(value))
    override val ipPermissions
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpPermission.wrap(item)
          }.toList
        )
    override val securityGroupRuleDescriptions: Optional[
      List[zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroupRuleDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SecurityGroupRuleDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
  ): zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest.ReadOnly =
    new Wrapper(impl)
}
