package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubnetConfiguration(
    subnetId: Optional[SubnetId] = Optional.Absent,
    ipv4: Optional[String] = Optional.Absent,
    ipv6: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SubnetConfiguration = {
    import SubnetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SubnetConfiguration
      .builder()
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(ipv4.map(value => value: java.lang.String))(_.ipv4)
      .optionallyWith(ipv6.map(value => value: java.lang.String))(_.ipv6)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SubnetConfiguration.ReadOnly =
    zio.aws.ec2.model.SubnetConfiguration.wrap(buildAwsValue())
}
object SubnetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SubnetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SubnetConfiguration =
      zio.aws.ec2.model.SubnetConfiguration(
        subnetId.map(value => value),
        ipv4.map(value => value),
        ipv6.map(value => value)
      )
    def subnetId: Optional[SubnetId]
    def ipv4: Optional[String]
    def ipv6: Optional[String]
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getIpv4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4", ipv4)
    def getIpv6: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6", ipv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SubnetConfiguration
  ) extends zio.aws.ec2.model.SubnetConfiguration.ReadOnly {
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val ipv4: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4())
      .map(value => value: String)
    override val ipv6: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SubnetConfiguration
  ): zio.aws.ec2.model.SubnetConfiguration.ReadOnly = new Wrapper(impl)
}
