package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartNetworkInsightsAccessScopeAnalysisResponse(
    networkInsightsAccessScopeAnalysis: Optional[
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse = {
    import StartNetworkInsightsAccessScopeAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysis.map(value => value.buildAwsValue())
      )(_.networkInsightsAccessScopeAnalysis)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly =
    zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse
      .wrap(buildAwsValue())
}
object StartNetworkInsightsAccessScopeAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse =
      zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse(
        networkInsightsAccessScopeAnalysis.map(value => value.asEditable)
      )
    def networkInsightsAccessScopeAnalysis: Optional[
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
    ]
    def getNetworkInsightsAccessScopeAnalysis: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInsightsAccessScopeAnalysis",
      networkInsightsAccessScopeAnalysis
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse
  ) extends zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly {
    override val networkInsightsAccessScopeAnalysis: Optional[
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeAnalysis())
      .map(value =>
        zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse
  ): zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
