package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class SlotStartTimeRangeRequest(
    earliestTime: Optional[DateTime] = Optional.Absent,
    latestTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest = {
    import SlotStartTimeRangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
      .builder()
      .optionallyWith(
        earliestTime.map(value => DateTime.unwrap(value): Instant)
      )(_.earliestTime)
      .optionallyWith(latestTime.map(value => DateTime.unwrap(value): Instant))(
        _.latestTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly =
    zio.aws.ec2.model.SlotStartTimeRangeRequest.wrap(buildAwsValue())
}
object SlotStartTimeRangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SlotStartTimeRangeRequest =
      zio.aws.ec2.model.SlotStartTimeRangeRequest(
        earliestTime.map(value => value),
        latestTime.map(value => value)
      )
    def earliestTime: Optional[DateTime]
    def latestTime: Optional[DateTime]
    def getEarliestTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("earliestTime", earliestTime)
    def getLatestTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("latestTime", latestTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
  ) extends zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly {
    override val earliestTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.earliestTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val latestTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.latestTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest
  ): zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly = new Wrapper(impl)
}
