package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesEbs(
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    volumeSize: Optional[Integer] = Optional.Absent,
    volumeType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs = {
    import ScheduledInstancesEbs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs
      .builder()
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(volumeType.map(value => value: java.lang.String))(
        _.volumeType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstancesEbs.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesEbs.wrap(buildAwsValue())
}
object ScheduledInstancesEbs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesEbs =
      zio.aws.ec2.model.ScheduledInstancesEbs(
        deleteOnTermination.map(value => value),
        encrypted.map(value => value),
        iops.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value)
      )
    def deleteOnTermination: Optional[Boolean]
    def encrypted: Optional[Boolean]
    def iops: Optional[Integer]
    def snapshotId: Optional[SnapshotId]
    def volumeSize: Optional[Integer]
    def volumeType: Optional[String]
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeType", volumeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs
  ) extends zio.aws.ec2.model.ScheduledInstancesEbs.ReadOnly {
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => value: Integer)
    override val volumeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs
  ): zio.aws.ec2.model.ScheduledInstancesEbs.ReadOnly = new Wrapper(impl)
}
