package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  RestoreSnapshotTierRequestTemporaryRestoreDays,
  SnapshotId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotTierRequest(
    snapshotId: SnapshotId,
    temporaryRestoreDays: Optional[
      RestoreSnapshotTierRequestTemporaryRestoreDays
    ] = Optional.Absent,
    permanentRestore: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest = {
    import RestoreSnapshotTierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(
        temporaryRestoreDays.map(value =>
          RestoreSnapshotTierRequestTemporaryRestoreDays.unwrap(value): Integer
        )
      )(_.temporaryRestoreDays)
      .optionallyWith(permanentRestore.map(value => value: java.lang.Boolean))(
        _.permanentRestore
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreSnapshotTierRequest.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotTierRequest.wrap(buildAwsValue())
}
object RestoreSnapshotTierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotTierRequest =
      zio.aws.ec2.model.RestoreSnapshotTierRequest(
        snapshotId,
        temporaryRestoreDays.map(value => value),
        permanentRestore.map(value => value),
        dryRun.map(value => value)
      )
    def snapshotId: SnapshotId
    def temporaryRestoreDays
        : Optional[RestoreSnapshotTierRequestTemporaryRestoreDays]
    def permanentRestore: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getTemporaryRestoreDays
        : ZIO[Any, AwsError, RestoreSnapshotTierRequestTemporaryRestoreDays] =
      AwsError.unwrapOptionField("temporaryRestoreDays", temporaryRestoreDays)
    def getPermanentRestore: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("permanentRestore", permanentRestore)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
  ) extends zio.aws.ec2.model.RestoreSnapshotTierRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val temporaryRestoreDays
        : Optional[RestoreSnapshotTierRequestTemporaryRestoreDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.temporaryRestoreDays())
        .map(value =>
          zio.aws.ec2.model.primitives
            .RestoreSnapshotTierRequestTemporaryRestoreDays(value)
        )
    override val permanentRestore: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.permanentRestore())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
  ): zio.aws.ec2.model.RestoreSnapshotTierRequest.ReadOnly = new Wrapper(impl)
}
