package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceVpnTunnelRequest(
    vpnConnectionId: VpnConnectionId,
    vpnTunnelOutsideIpAddress: String,
    applyPendingMaintenance: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest = {
    import ReplaceVpnTunnelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .vpnTunnelOutsideIpAddress(vpnTunnelOutsideIpAddress: java.lang.String)
      .optionallyWith(
        applyPendingMaintenance.map(value => value: java.lang.Boolean)
      )(_.applyPendingMaintenance)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReplaceVpnTunnelRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceVpnTunnelRequest.wrap(buildAwsValue())
}
object ReplaceVpnTunnelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceVpnTunnelRequest =
      zio.aws.ec2.model.ReplaceVpnTunnelRequest(
        vpnConnectionId,
        vpnTunnelOutsideIpAddress,
        applyPendingMaintenance.map(value => value),
        dryRun.map(value => value)
      )
    def vpnConnectionId: VpnConnectionId
    def vpnTunnelOutsideIpAddress: String
    def applyPendingMaintenance: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getVpnTunnelOutsideIpAddress: ZIO[Any, Nothing, String] =
      ZIO.succeed(vpnTunnelOutsideIpAddress)
    def getApplyPendingMaintenance: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("applyPendingMaintenance", applyPendingMaintenance)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest
  ) extends zio.aws.ec2.model.ReplaceVpnTunnelRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val vpnTunnelOutsideIpAddress: String =
      impl.vpnTunnelOutsideIpAddress(): String
    override val applyPendingMaintenance: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyPendingMaintenance())
        .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest
  ): zio.aws.ec2.model.ReplaceVpnTunnelRequest.ReadOnly = new Wrapper(impl)
}
