package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.OfferingId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PurchaseCapacityBlockRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    capacityBlockOfferingId: OfferingId,
    instancePlatform: zio.aws.ec2.model.CapacityReservationInstancePlatform
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest = {
    import PurchaseCapacityBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .capacityBlockOfferingId(
        OfferingId.unwrap(capacityBlockOfferingId): java.lang.String
      )
      .instancePlatform(instancePlatform.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PurchaseCapacityBlockRequest.ReadOnly =
    zio.aws.ec2.model.PurchaseCapacityBlockRequest.wrap(buildAwsValue())
}
object PurchaseCapacityBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseCapacityBlockRequest =
      zio.aws.ec2.model.PurchaseCapacityBlockRequest(
        dryRun.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capacityBlockOfferingId,
        instancePlatform
      )
    def dryRun: Optional[Boolean]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def capacityBlockOfferingId: OfferingId
    def instancePlatform: zio.aws.ec2.model.CapacityReservationInstancePlatform
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getCapacityBlockOfferingId: ZIO[Any, Nothing, OfferingId] =
      ZIO.succeed(capacityBlockOfferingId)
    def getInstancePlatform: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = ZIO.succeed(instancePlatform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest
  ) extends zio.aws.ec2.model.PurchaseCapacityBlockRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val capacityBlockOfferingId: OfferingId =
      zio.aws.ec2.model.primitives.OfferingId(impl.capacityBlockOfferingId())
    override val instancePlatform
        : zio.aws.ec2.model.CapacityReservationInstancePlatform =
      zio.aws.ec2.model.CapacityReservationInstancePlatform
        .wrap(impl.instancePlatform())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest
  ): zio.aws.ec2.model.PurchaseCapacityBlockRequest.ReadOnly = new Wrapper(impl)
}
