package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PartitionLoadFrequency {
  def unwrap: software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency
}
object PartitionLoadFrequency {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency
  ): zio.aws.ec2.model.PartitionLoadFrequency = value match {
    case software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.DAILY =>
      val r = daily
      r
    case software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.WEEKLY =>
      val r = weekly
      r
    case software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.MONTHLY =>
      val r = monthly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.PartitionLoadFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency =
      software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.ec2.model.PartitionLoadFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency =
      software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.NONE
  }
  case object daily extends zio.aws.ec2.model.PartitionLoadFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency =
      software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.DAILY
  }
  case object weekly extends zio.aws.ec2.model.PartitionLoadFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency =
      software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.WEEKLY
  }
  case object monthly extends zio.aws.ec2.model.PartitionLoadFrequency {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency =
      software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency.MONTHLY
  }
}
