package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterfacePermission(
    networkInterfacePermissionId: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    awsAccountId: Optional[String] = Optional.Absent,
    awsService: Optional[String] = Optional.Absent,
    permission: Optional[zio.aws.ec2.model.InterfacePermissionType] =
      Optional.Absent,
    permissionState: Optional[
      zio.aws.ec2.model.NetworkInterfacePermissionState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission = {
    import NetworkInterfacePermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission
      .builder()
      .optionallyWith(
        networkInterfacePermissionId.map(value => value: java.lang.String)
      )(_.networkInterfacePermissionId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(awsAccountId.map(value => value: java.lang.String))(
        _.awsAccountId
      )
      .optionallyWith(awsService.map(value => value: java.lang.String))(
        _.awsService
      )
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .optionallyWith(permissionState.map(value => value.buildAwsValue()))(
        _.permissionState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly =
    zio.aws.ec2.model.NetworkInterfacePermission.wrap(buildAwsValue())
}
object NetworkInterfacePermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfacePermission =
      zio.aws.ec2.model.NetworkInterfacePermission(
        networkInterfacePermissionId.map(value => value),
        networkInterfaceId.map(value => value),
        awsAccountId.map(value => value),
        awsService.map(value => value),
        permission.map(value => value),
        permissionState.map(value => value.asEditable)
      )
    def networkInterfacePermissionId: Optional[String]
    def networkInterfaceId: Optional[String]
    def awsAccountId: Optional[String]
    def awsService: Optional[String]
    def permission: Optional[zio.aws.ec2.model.InterfacePermissionType]
    def permissionState
        : Optional[zio.aws.ec2.model.NetworkInterfacePermissionState.ReadOnly]
    def getNetworkInterfacePermissionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "networkInterfacePermissionId",
        networkInterfacePermissionId
      )
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getAwsAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsService: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsService", awsService)
    def getPermission
        : ZIO[Any, AwsError, zio.aws.ec2.model.InterfacePermissionType] =
      AwsError.unwrapOptionField("permission", permission)
    def getPermissionState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfacePermissionState.ReadOnly
    ] = AwsError.unwrapOptionField("permissionState", permissionState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission
  ) extends zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly {
    override val networkInterfacePermissionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfacePermissionId())
        .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val awsAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => value: String)
    override val awsService: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsService())
      .map(value => value: String)
    override val permission
        : Optional[zio.aws.ec2.model.InterfacePermissionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permission())
        .map(value => zio.aws.ec2.model.InterfacePermissionType.wrap(value))
    override val permissionState
        : Optional[zio.aws.ec2.model.NetworkInterfacePermissionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionState())
        .map(value =>
          zio.aws.ec2.model.NetworkInterfacePermissionState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission
  ): zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly = new Wrapper(impl)
}
