package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpnTunnelCertificateRequest(
    vpnConnectionId: VpnConnectionId,
    vpnTunnelOutsideIpAddress: String,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest = {
    import ModifyVpnTunnelCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .vpnTunnelOutsideIpAddress(vpnTunnelOutsideIpAddress: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.wrap(buildAwsValue())
}
object ModifyVpnTunnelCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest =
      zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest(
        vpnConnectionId,
        vpnTunnelOutsideIpAddress,
        dryRun.map(value => value)
      )
    def vpnConnectionId: VpnConnectionId
    def vpnTunnelOutsideIpAddress: String
    def dryRun: Optional[Boolean]
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getVpnTunnelOutsideIpAddress: ZIO[Any, Nothing, String] =
      ZIO.succeed(vpnTunnelOutsideIpAddress)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
  ) extends zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val vpnTunnelOutsideIpAddress: String =
      impl.vpnTunnelOutsideIpAddress(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
  ): zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
