package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayRequest(
    transitGatewayId: TransitGatewayId,
    description: Optional[String] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.ModifyTransitGatewayOptions] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest = {
    import ModifyTransitGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyTransitGatewayRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayRequest.wrap(buildAwsValue())
}
object ModifyTransitGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayRequest =
      zio.aws.ec2.model.ModifyTransitGatewayRequest(
        transitGatewayId,
        description.map(value => value),
        options.map(value => value.asEditable),
        dryRun.map(value => value)
      )
    def transitGatewayId: TransitGatewayId
    def description: Optional[String]
    def options
        : Optional[zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly]
    def dryRun: Optional[Boolean]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
  ) extends zio.aws.ec2.model.ModifyTransitGatewayRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val options
        : Optional[zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.ec2.model.ModifyTransitGatewayOptions.wrap(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
  ): zio.aws.ec2.model.ModifyTransitGatewayRequest.ReadOnly = new Wrapper(impl)
}
