package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  TrafficMirrorFilterRuleIdWithResolver
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorFilterRuleRequest(
    trafficMirrorFilterRuleId: TrafficMirrorFilterRuleIdWithResolver,
    trafficDirection: Optional[zio.aws.ec2.model.TrafficDirection] =
      Optional.Absent,
    ruleNumber: Optional[Integer] = Optional.Absent,
    ruleAction: Optional[zio.aws.ec2.model.TrafficMirrorRuleAction] =
      Optional.Absent,
    destinationPortRange: Optional[
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest
    ] = Optional.Absent,
    sourcePortRange: Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest] =
      Optional.Absent,
    protocol: Optional[Integer] = Optional.Absent,
    destinationCidrBlock: Optional[String] = Optional.Absent,
    sourceCidrBlock: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    removeFields: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilterRuleField]
    ] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest = {
    import ModifyTrafficMirrorFilterRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
      .builder()
      .trafficMirrorFilterRuleId(
        TrafficMirrorFilterRuleIdWithResolver.unwrap(
          trafficMirrorFilterRuleId
        ): java.lang.String
      )
      .optionallyWith(trafficDirection.map(value => value.unwrap))(
        _.trafficDirection
      )
      .optionallyWith(ruleNumber.map(value => value: java.lang.Integer))(
        _.ruleNumber
      )
      .optionallyWith(ruleAction.map(value => value.unwrap))(_.ruleAction)
      .optionallyWith(destinationPortRange.map(value => value.buildAwsValue()))(
        _.destinationPortRange
      )
      .optionallyWith(sourcePortRange.map(value => value.buildAwsValue()))(
        _.sourcePortRange
      )
      .optionallyWith(protocol.map(value => value: java.lang.Integer))(
        _.protocol
      )
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(sourceCidrBlock.map(value => value: java.lang.String))(
        _.sourceCidrBlock
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        removeFields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.removeFieldsWithStrings)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.wrap(buildAwsValue())
}
object ModifyTrafficMirrorFilterRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest =
      zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest(
        trafficMirrorFilterRuleId,
        trafficDirection.map(value => value),
        ruleNumber.map(value => value),
        ruleAction.map(value => value),
        destinationPortRange.map(value => value.asEditable),
        sourcePortRange.map(value => value.asEditable),
        protocol.map(value => value),
        destinationCidrBlock.map(value => value),
        sourceCidrBlock.map(value => value),
        description.map(value => value),
        removeFields.map(value => value),
        dryRun.map(value => value)
      )
    def trafficMirrorFilterRuleId: TrafficMirrorFilterRuleIdWithResolver
    def trafficDirection: Optional[zio.aws.ec2.model.TrafficDirection]
    def ruleNumber: Optional[Integer]
    def ruleAction: Optional[zio.aws.ec2.model.TrafficMirrorRuleAction]
    def destinationPortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly]
    def sourcePortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly]
    def protocol: Optional[Integer]
    def destinationCidrBlock: Optional[String]
    def sourceCidrBlock: Optional[String]
    def description: Optional[String]
    def removeFields
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilterRuleField]]
    def dryRun: Optional[Boolean]
    def getTrafficMirrorFilterRuleId
        : ZIO[Any, Nothing, TrafficMirrorFilterRuleIdWithResolver] =
      ZIO.succeed(trafficMirrorFilterRuleId)
    def getTrafficDirection
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficDirection] =
      AwsError.unwrapOptionField("trafficDirection", trafficDirection)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
    def getRuleAction
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorRuleAction] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getDestinationPortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
    def getSourcePortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getProtocol: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getSourceCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCidrBlock", sourceCidrBlock)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getRemoveFields: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilterRuleField
    ]] = AwsError.unwrapOptionField("removeFields", removeFields)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.ReadOnly {
    override val trafficMirrorFilterRuleId
        : TrafficMirrorFilterRuleIdWithResolver = zio.aws.ec2.model.primitives
      .TrafficMirrorFilterRuleIdWithResolver(impl.trafficMirrorFilterRuleId())
    override val trafficDirection
        : Optional[zio.aws.ec2.model.TrafficDirection] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficDirection())
      .map(value => zio.aws.ec2.model.TrafficDirection.wrap(value))
    override val ruleNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleNumber())
      .map(value => value: Integer)
    override val ruleAction
        : Optional[zio.aws.ec2.model.TrafficMirrorRuleAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleAction())
        .map(value => zio.aws.ec2.model.TrafficMirrorRuleAction.wrap(value))
    override val destinationPortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPortRange())
        .map(value =>
          zio.aws.ec2.model.TrafficMirrorPortRangeRequest.wrap(value)
        )
    override val sourcePortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePortRange())
        .map(value =>
          zio.aws.ec2.model.TrafficMirrorPortRangeRequest.wrap(value)
        )
    override val protocol: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: Integer)
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val sourceCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCidrBlock())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val removeFields
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilterRuleField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorFilterRuleField.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ): zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.ReadOnly =
    new Wrapper(impl)
}
