package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifySecurityGroupRulesRequest(
    groupId: SecurityGroupId,
    securityGroupRules: Iterable[zio.aws.ec2.model.SecurityGroupRuleUpdate],
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest = {
    import ModifySecurityGroupRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
      .builder()
      .groupId(SecurityGroupId.unwrap(groupId): java.lang.String)
      .securityGroupRules(securityGroupRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySecurityGroupRulesRequest.ReadOnly =
    zio.aws.ec2.model.ModifySecurityGroupRulesRequest.wrap(buildAwsValue())
}
object ModifySecurityGroupRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySecurityGroupRulesRequest =
      zio.aws.ec2.model.ModifySecurityGroupRulesRequest(
        groupId,
        securityGroupRules.map { item =>
          item.asEditable
        },
        dryRun.map(value => value)
      )
    def groupId: SecurityGroupId
    def securityGroupRules
        : List[zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly]
    def dryRun: Optional[Boolean]
    def getGroupId: ZIO[Any, Nothing, SecurityGroupId] = ZIO.succeed(groupId)
    def getSecurityGroupRules: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly
    ]] = ZIO.succeed(securityGroupRules)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
  ) extends zio.aws.ec2.model.ModifySecurityGroupRulesRequest.ReadOnly {
    override val groupId: SecurityGroupId =
      zio.aws.ec2.model.primitives.SecurityGroupId(impl.groupId())
    override val securityGroupRules
        : List[zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly] = impl
      .securityGroupRules()
      .asScala
      .map { item =>
        zio.aws.ec2.model.SecurityGroupRuleUpdate.wrap(item)
      }
      .toList
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest
  ): zio.aws.ec2.model.ModifySecurityGroupRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
