package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  NetworkInterfaceId,
  LocalGatewayVirtualInterfaceGroupId,
  LocalGatewayRoutetableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyLocalGatewayRouteRequest(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    localGatewayVirtualInterfaceGroupId: Optional[
      LocalGatewayVirtualInterfaceGroupId
    ] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    destinationPrefixListId: Optional[PrefixListResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest = {
    import ModifyLocalGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.wrap(buildAwsValue())
}
object ModifyLocalGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyLocalGatewayRouteRequest =
      zio.aws.ec2.model.ModifyLocalGatewayRouteRequest(
        destinationCidrBlock.map(value => value),
        localGatewayRouteTableId,
        localGatewayVirtualInterfaceGroupId.map(value => value),
        networkInterfaceId.map(value => value),
        dryRun.map(value => value),
        destinationPrefixListId.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def dryRun: Optional[Boolean]
    def destinationPrefixListId: Optional[PrefixListResourceId]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getDestinationPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
  ) extends zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val destinationPrefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
  ): zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
