package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LaunchTemplateName, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyLaunchTemplateRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    launchTemplateId: Optional[LaunchTemplateId] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    defaultVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest = {
    import ModifyLaunchTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(defaultVersion.map(value => value: java.lang.String))(
        _.defaultVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyLaunchTemplateRequest.ReadOnly =
    zio.aws.ec2.model.ModifyLaunchTemplateRequest.wrap(buildAwsValue())
}
object ModifyLaunchTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyLaunchTemplateRequest =
      zio.aws.ec2.model.ModifyLaunchTemplateRequest(
        dryRun.map(value => value),
        clientToken.map(value => value),
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        defaultVersion.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def launchTemplateId: Optional[LaunchTemplateId]
    def launchTemplateName: Optional[LaunchTemplateName]
    def defaultVersion: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getDefaultVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
  ) extends zio.aws.ec2.model.ModifyLaunchTemplateRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val launchTemplateId: Optional[LaunchTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateId())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val defaultVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
  ): zio.aws.ec2.model.ModifyLaunchTemplateRequest.ReadOnly = new Wrapper(impl)
}
