package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyFleetRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    excessCapacityTerminationPolicy: Optional[
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = Optional.Absent,
    launchTemplateConfigs: Optional[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest]
    ] = Optional.Absent,
    fleetId: FleetId,
    targetCapacitySpecification: Optional[
      zio.aws.ec2.model.TargetCapacitySpecificationRequest
    ] = Optional.Absent,
    context: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyFleetRequest = {
    import ModifyFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        targetCapacitySpecification.map(value => value.buildAwsValue())
      )(_.targetCapacitySpecification)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyFleetRequest.ReadOnly =
    zio.aws.ec2.model.ModifyFleetRequest.wrap(buildAwsValue())
}
object ModifyFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyFleetRequest =
      zio.aws.ec2.model.ModifyFleetRequest(
        dryRun.map(value => value),
        excessCapacityTerminationPolicy.map(value => value),
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fleetId,
        targetCapacitySpecification.map(value => value.asEditable),
        context.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy]
    def launchTemplateConfigs: Optional[
      List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly]
    ]
    def fleetId: FleetId
    def targetCapacitySpecification: Optional[
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ]
    def context: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getTargetCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetCapacitySpecification",
      targetCapacitySpecification
    )
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
  ) extends zio.aws.ec2.model.ModifyFleetRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excessCapacityTerminationPolicy())
        .map(value =>
          zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy.wrap(value)
        )
    override val launchTemplateConfigs: Optional[
      List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.wrap(item)
        }.toList
      )
    override val fleetId: FleetId =
      zio.aws.ec2.model.primitives.FleetId(impl.fleetId())
    override val targetCapacitySpecification: Optional[
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetCapacitySpecification())
      .map(value =>
        zio.aws.ec2.model.TargetCapacitySpecificationRequest.wrap(value)
      )
    override val context: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.context())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
  ): zio.aws.ec2.model.ModifyFleetRequest.ReadOnly = new Wrapper(impl)
}
