package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VpcId,
  SecurityGroupId,
  Integer,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyClientVpnEndpointRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    serverCertificateArn: Optional[String] = Optional.Absent,
    connectionLogOptions: Optional[zio.aws.ec2.model.ConnectionLogOptions] =
      Optional.Absent,
    dnsServers: Optional[zio.aws.ec2.model.DnsServersOptionsModifyStructure] =
      Optional.Absent,
    vpnPort: Optional[Integer] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    splitTunnel: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    selfServicePortal: Optional[zio.aws.ec2.model.SelfServicePortal] =
      Optional.Absent,
    clientConnectOptions: Optional[zio.aws.ec2.model.ClientConnectOptions] =
      Optional.Absent,
    sessionTimeoutHours: Optional[Integer] = Optional.Absent,
    clientLoginBannerOptions: Optional[
      zio.aws.ec2.model.ClientLoginBannerOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest = {
    import ModifyClientVpnEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        serverCertificateArn.map(value => value: java.lang.String)
      )(_.serverCertificateArn)
      .optionallyWith(connectionLogOptions.map(value => value.buildAwsValue()))(
        _.connectionLogOptions
      )
      .optionallyWith(dnsServers.map(value => value.buildAwsValue()))(
        _.dnsServers
      )
      .optionallyWith(vpnPort.map(value => value: java.lang.Integer))(_.vpnPort)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(splitTunnel.map(value => value: java.lang.Boolean))(
        _.splitTunnel
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(selfServicePortal.map(value => value.unwrap))(
        _.selfServicePortal
      )
      .optionallyWith(clientConnectOptions.map(value => value.buildAwsValue()))(
        _.clientConnectOptions
      )
      .optionallyWith(
        sessionTimeoutHours.map(value => value: java.lang.Integer)
      )(_.sessionTimeoutHours)
      .optionallyWith(
        clientLoginBannerOptions.map(value => value.buildAwsValue())
      )(_.clientLoginBannerOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyClientVpnEndpointRequest.ReadOnly =
    zio.aws.ec2.model.ModifyClientVpnEndpointRequest.wrap(buildAwsValue())
}
object ModifyClientVpnEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyClientVpnEndpointRequest =
      zio.aws.ec2.model.ModifyClientVpnEndpointRequest(
        clientVpnEndpointId,
        serverCertificateArn.map(value => value),
        connectionLogOptions.map(value => value.asEditable),
        dnsServers.map(value => value.asEditable),
        vpnPort.map(value => value),
        description.map(value => value),
        splitTunnel.map(value => value),
        dryRun.map(value => value),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        selfServicePortal.map(value => value),
        clientConnectOptions.map(value => value.asEditable),
        sessionTimeoutHours.map(value => value),
        clientLoginBannerOptions.map(value => value.asEditable)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def serverCertificateArn: Optional[String]
    def connectionLogOptions
        : Optional[zio.aws.ec2.model.ConnectionLogOptions.ReadOnly]
    def dnsServers
        : Optional[zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly]
    def vpnPort: Optional[Integer]
    def description: Optional[String]
    def splitTunnel: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def vpcId: Optional[VpcId]
    def selfServicePortal: Optional[zio.aws.ec2.model.SelfServicePortal]
    def clientConnectOptions
        : Optional[zio.aws.ec2.model.ClientConnectOptions.ReadOnly]
    def sessionTimeoutHours: Optional[Integer]
    def clientLoginBannerOptions
        : Optional[zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getServerCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverCertificateArn", serverCertificateArn)
    def getConnectionLogOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectionLogOptions.ReadOnly] =
      AwsError.unwrapOptionField("connectionLogOptions", connectionLogOptions)
    def getDnsServers: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly
    ] = AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getVpnPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpnPort", vpnPort)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSplitTunnel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("splitTunnel", splitTunnel)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSelfServicePortal
        : ZIO[Any, AwsError, zio.aws.ec2.model.SelfServicePortal] =
      AwsError.unwrapOptionField("selfServicePortal", selfServicePortal)
    def getClientConnectOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientConnectOptions.ReadOnly] =
      AwsError.unwrapOptionField("clientConnectOptions", clientConnectOptions)
    def getSessionTimeoutHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sessionTimeoutHours", sessionTimeoutHours)
    def getClientLoginBannerOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientLoginBannerOptions",
      clientLoginBannerOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
  ) extends zio.aws.ec2.model.ModifyClientVpnEndpointRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val serverCertificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverCertificateArn())
      .map(value => value: String)
    override val connectionLogOptions
        : Optional[zio.aws.ec2.model.ConnectionLogOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionLogOptions())
        .map(value => zio.aws.ec2.model.ConnectionLogOptions.wrap(value))
    override val dnsServers: Optional[
      zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsServers())
      .map(value =>
        zio.aws.ec2.model.DnsServersOptionsModifyStructure.wrap(value)
      )
    override val vpnPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnPort())
      .map(value => value: Integer)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val splitTunnel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.splitTunnel())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val selfServicePortal
        : Optional[zio.aws.ec2.model.SelfServicePortal] = zio.aws.core.internal
      .optionalFromNullable(impl.selfServicePortal())
      .map(value => zio.aws.ec2.model.SelfServicePortal.wrap(value))
    override val clientConnectOptions
        : Optional[zio.aws.ec2.model.ClientConnectOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientConnectOptions())
        .map(value => zio.aws.ec2.model.ClientConnectOptions.wrap(value))
    override val sessionTimeoutHours: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionTimeoutHours())
      .map(value => value: Integer)
    override val clientLoginBannerOptions
        : Optional[zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientLoginBannerOptions())
        .map(value => zio.aws.ec2.model.ClientLoginBannerOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
  ): zio.aws.ec2.model.ModifyClientVpnEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
