package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LocalGatewayRouteTableMode {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode
}
object LocalGatewayRouteTableMode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode
  ): zio.aws.ec2.model.LocalGatewayRouteTableMode = value match {
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode.DIRECT_VPC_ROUTING =>
      val r = `direct-vpc-routing`
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode.COIP =>
      val r = coip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LocalGatewayRouteTableMode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode.UNKNOWN_TO_SDK_VERSION
  }
  case object `direct-vpc-routing`
      extends zio.aws.ec2.model.LocalGatewayRouteTableMode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode.DIRECT_VPC_ROUTING
  }
  case object coip extends zio.aws.ec2.model.LocalGatewayRouteTableMode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableMode.COIP
  }
}
