package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  SnapshotId,
  ListSnapshotsInRecycleBinMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSnapshotsInRecycleBinRequest(
    maxResults: Optional[ListSnapshotsInRecycleBinMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    snapshotIds: Optional[Iterable[SnapshotId]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest = {
    import ListSnapshotsInRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSnapshotsInRecycleBinMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        snapshotIds.map(value =>
          value.map { item =>
            SnapshotId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.wrap(buildAwsValue())
}
object ListSnapshotsInRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest =
      zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        snapshotIds.map(value => value),
        dryRun.map(value => value)
      )
    def maxResults: Optional[ListSnapshotsInRecycleBinMaxResults]
    def nextToken: Optional[String]
    def snapshotIds: Optional[List[SnapshotId]]
    def dryRun: Optional[Boolean]
    def getMaxResults: ZIO[Any, AwsError, ListSnapshotsInRecycleBinMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSnapshotIds: ZIO[Any, AwsError, List[SnapshotId]] =
      AwsError.unwrapOptionField("snapshotIds", snapshotIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
  ) extends zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.ReadOnly {
    override val maxResults: Optional[ListSnapshotsInRecycleBinMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .ListSnapshotsInRecycleBinMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val snapshotIds: Optional[List[SnapshotId]] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SnapshotId(item)
        }.toList
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
  ): zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.ReadOnly = new Wrapper(
    impl
  )
}
