package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchPermissionModifications(
    add: Optional[Iterable[zio.aws.ec2.model.LaunchPermission]] =
      Optional.Absent,
    remove: Optional[Iterable[zio.aws.ec2.model.LaunchPermission]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications = {
    import LaunchPermissionModifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications
      .builder()
      .optionallyWith(
        add.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.add)
      .optionallyWith(
        remove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remove)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly =
    zio.aws.ec2.model.LaunchPermissionModifications.wrap(buildAwsValue())
}
object LaunchPermissionModifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchPermissionModifications =
      zio.aws.ec2.model.LaunchPermissionModifications(
        add.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def add: Optional[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]]
    def remove: Optional[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]]
    def getAdd: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("add", add)
    def getRemove: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("remove", remove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications
  ) extends zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly {
    override val add
        : Optional[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.add())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LaunchPermission.wrap(item)
          }.toList
        )
    override val remove
        : Optional[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LaunchPermission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications
  ): zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly = new Wrapper(
    impl
  )
}
