package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  BurstablePerformanceFlag,
  BareMetalFlag,
  FreeTierEligibleFlag,
  HibernationFlag,
  AutoRecoveryFlag,
  InstanceStorageFlag,
  CurrentGenerationFlag,
  DedicatedHostFlag
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceTypeInfo(
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    currentGeneration: Optional[CurrentGenerationFlag] = Optional.Absent,
    freeTierEligible: Optional[FreeTierEligibleFlag] = Optional.Absent,
    supportedUsageClasses: Optional[
      Iterable[zio.aws.ec2.model.UsageClassType]
    ] = Optional.Absent,
    supportedRootDeviceTypes: Optional[
      Iterable[zio.aws.ec2.model.RootDeviceType]
    ] = Optional.Absent,
    supportedVirtualizationTypes: Optional[
      Iterable[zio.aws.ec2.model.VirtualizationType]
    ] = Optional.Absent,
    bareMetal: Optional[BareMetalFlag] = Optional.Absent,
    hypervisor: Optional[zio.aws.ec2.model.InstanceTypeHypervisor] =
      Optional.Absent,
    processorInfo: Optional[zio.aws.ec2.model.ProcessorInfo] = Optional.Absent,
    vCpuInfo: Optional[zio.aws.ec2.model.VCpuInfo] = Optional.Absent,
    memoryInfo: Optional[zio.aws.ec2.model.MemoryInfo] = Optional.Absent,
    instanceStorageSupported: Optional[InstanceStorageFlag] = Optional.Absent,
    instanceStorageInfo: Optional[zio.aws.ec2.model.InstanceStorageInfo] =
      Optional.Absent,
    ebsInfo: Optional[zio.aws.ec2.model.EbsInfo] = Optional.Absent,
    networkInfo: Optional[zio.aws.ec2.model.NetworkInfo] = Optional.Absent,
    gpuInfo: Optional[zio.aws.ec2.model.GpuInfo] = Optional.Absent,
    fpgaInfo: Optional[zio.aws.ec2.model.FpgaInfo] = Optional.Absent,
    placementGroupInfo: Optional[zio.aws.ec2.model.PlacementGroupInfo] =
      Optional.Absent,
    inferenceAcceleratorInfo: Optional[
      zio.aws.ec2.model.InferenceAcceleratorInfo
    ] = Optional.Absent,
    hibernationSupported: Optional[HibernationFlag] = Optional.Absent,
    burstablePerformanceSupported: Optional[BurstablePerformanceFlag] =
      Optional.Absent,
    dedicatedHostsSupported: Optional[DedicatedHostFlag] = Optional.Absent,
    autoRecoverySupported: Optional[AutoRecoveryFlag] = Optional.Absent,
    supportedBootModes: Optional[Iterable[zio.aws.ec2.model.BootModeType]] =
      Optional.Absent,
    nitroEnclavesSupport: Optional[zio.aws.ec2.model.NitroEnclavesSupport] =
      Optional.Absent,
    nitroTpmSupport: Optional[zio.aws.ec2.model.NitroTpmSupport] =
      Optional.Absent,
    nitroTpmInfo: Optional[zio.aws.ec2.model.NitroTpmInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceTypeInfo = {
    import InstanceTypeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        currentGeneration.map(value =>
          CurrentGenerationFlag.unwrap(value): java.lang.Boolean
        )
      )(_.currentGeneration)
      .optionallyWith(
        freeTierEligible.map(value =>
          FreeTierEligibleFlag.unwrap(value): java.lang.Boolean
        )
      )(_.freeTierEligible)
      .optionallyWith(
        supportedUsageClasses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedUsageClassesWithStrings)
      .optionallyWith(
        supportedRootDeviceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedRootDeviceTypesWithStrings)
      .optionallyWith(
        supportedVirtualizationTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedVirtualizationTypesWithStrings)
      .optionallyWith(
        bareMetal.map(value => BareMetalFlag.unwrap(value): java.lang.Boolean)
      )(_.bareMetal)
      .optionallyWith(hypervisor.map(value => value.unwrap))(_.hypervisor)
      .optionallyWith(processorInfo.map(value => value.buildAwsValue()))(
        _.processorInfo
      )
      .optionallyWith(vCpuInfo.map(value => value.buildAwsValue()))(_.vCpuInfo)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .optionallyWith(
        instanceStorageSupported.map(value =>
          InstanceStorageFlag.unwrap(value): java.lang.Boolean
        )
      )(_.instanceStorageSupported)
      .optionallyWith(instanceStorageInfo.map(value => value.buildAwsValue()))(
        _.instanceStorageInfo
      )
      .optionallyWith(ebsInfo.map(value => value.buildAwsValue()))(_.ebsInfo)
      .optionallyWith(networkInfo.map(value => value.buildAwsValue()))(
        _.networkInfo
      )
      .optionallyWith(gpuInfo.map(value => value.buildAwsValue()))(_.gpuInfo)
      .optionallyWith(fpgaInfo.map(value => value.buildAwsValue()))(_.fpgaInfo)
      .optionallyWith(placementGroupInfo.map(value => value.buildAwsValue()))(
        _.placementGroupInfo
      )
      .optionallyWith(
        inferenceAcceleratorInfo.map(value => value.buildAwsValue())
      )(_.inferenceAcceleratorInfo)
      .optionallyWith(
        hibernationSupported.map(value =>
          HibernationFlag.unwrap(value): java.lang.Boolean
        )
      )(_.hibernationSupported)
      .optionallyWith(
        burstablePerformanceSupported.map(value =>
          BurstablePerformanceFlag.unwrap(value): java.lang.Boolean
        )
      )(_.burstablePerformanceSupported)
      .optionallyWith(
        dedicatedHostsSupported.map(value =>
          DedicatedHostFlag.unwrap(value): java.lang.Boolean
        )
      )(_.dedicatedHostsSupported)
      .optionallyWith(
        autoRecoverySupported.map(value =>
          AutoRecoveryFlag.unwrap(value): java.lang.Boolean
        )
      )(_.autoRecoverySupported)
      .optionallyWith(
        supportedBootModes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedBootModesWithStrings)
      .optionallyWith(nitroEnclavesSupport.map(value => value.unwrap))(
        _.nitroEnclavesSupport
      )
      .optionallyWith(nitroTpmSupport.map(value => value.unwrap))(
        _.nitroTpmSupport
      )
      .optionallyWith(nitroTpmInfo.map(value => value.buildAwsValue()))(
        _.nitroTpmInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceTypeInfo.ReadOnly =
    zio.aws.ec2.model.InstanceTypeInfo.wrap(buildAwsValue())
}
object InstanceTypeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceTypeInfo =
      zio.aws.ec2.model.InstanceTypeInfo(
        instanceType.map(value => value),
        currentGeneration.map(value => value),
        freeTierEligible.map(value => value),
        supportedUsageClasses.map(value => value),
        supportedRootDeviceTypes.map(value => value),
        supportedVirtualizationTypes.map(value => value),
        bareMetal.map(value => value),
        hypervisor.map(value => value),
        processorInfo.map(value => value.asEditable),
        vCpuInfo.map(value => value.asEditable),
        memoryInfo.map(value => value.asEditable),
        instanceStorageSupported.map(value => value),
        instanceStorageInfo.map(value => value.asEditable),
        ebsInfo.map(value => value.asEditable),
        networkInfo.map(value => value.asEditable),
        gpuInfo.map(value => value.asEditable),
        fpgaInfo.map(value => value.asEditable),
        placementGroupInfo.map(value => value.asEditable),
        inferenceAcceleratorInfo.map(value => value.asEditable),
        hibernationSupported.map(value => value),
        burstablePerformanceSupported.map(value => value),
        dedicatedHostsSupported.map(value => value),
        autoRecoverySupported.map(value => value),
        supportedBootModes.map(value => value),
        nitroEnclavesSupport.map(value => value),
        nitroTpmSupport.map(value => value),
        nitroTpmInfo.map(value => value.asEditable)
      )
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def currentGeneration: Optional[CurrentGenerationFlag]
    def freeTierEligible: Optional[FreeTierEligibleFlag]
    def supportedUsageClasses: Optional[List[zio.aws.ec2.model.UsageClassType]]
    def supportedRootDeviceTypes
        : Optional[List[zio.aws.ec2.model.RootDeviceType]]
    def supportedVirtualizationTypes
        : Optional[List[zio.aws.ec2.model.VirtualizationType]]
    def bareMetal: Optional[BareMetalFlag]
    def hypervisor: Optional[zio.aws.ec2.model.InstanceTypeHypervisor]
    def processorInfo: Optional[zio.aws.ec2.model.ProcessorInfo.ReadOnly]
    def vCpuInfo: Optional[zio.aws.ec2.model.VCpuInfo.ReadOnly]
    def memoryInfo: Optional[zio.aws.ec2.model.MemoryInfo.ReadOnly]
    def instanceStorageSupported: Optional[InstanceStorageFlag]
    def instanceStorageInfo
        : Optional[zio.aws.ec2.model.InstanceStorageInfo.ReadOnly]
    def ebsInfo: Optional[zio.aws.ec2.model.EbsInfo.ReadOnly]
    def networkInfo: Optional[zio.aws.ec2.model.NetworkInfo.ReadOnly]
    def gpuInfo: Optional[zio.aws.ec2.model.GpuInfo.ReadOnly]
    def fpgaInfo: Optional[zio.aws.ec2.model.FpgaInfo.ReadOnly]
    def placementGroupInfo
        : Optional[zio.aws.ec2.model.PlacementGroupInfo.ReadOnly]
    def inferenceAcceleratorInfo
        : Optional[zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly]
    def hibernationSupported: Optional[HibernationFlag]
    def burstablePerformanceSupported: Optional[BurstablePerformanceFlag]
    def dedicatedHostsSupported: Optional[DedicatedHostFlag]
    def autoRecoverySupported: Optional[AutoRecoveryFlag]
    def supportedBootModes: Optional[List[zio.aws.ec2.model.BootModeType]]
    def nitroEnclavesSupport: Optional[zio.aws.ec2.model.NitroEnclavesSupport]
    def nitroTpmSupport: Optional[zio.aws.ec2.model.NitroTpmSupport]
    def nitroTpmInfo: Optional[zio.aws.ec2.model.NitroTpmInfo.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getCurrentGeneration: ZIO[Any, AwsError, CurrentGenerationFlag] =
      AwsError.unwrapOptionField("currentGeneration", currentGeneration)
    def getFreeTierEligible: ZIO[Any, AwsError, FreeTierEligibleFlag] =
      AwsError.unwrapOptionField("freeTierEligible", freeTierEligible)
    def getSupportedUsageClasses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.UsageClassType]] =
      AwsError.unwrapOptionField("supportedUsageClasses", supportedUsageClasses)
    def getSupportedRootDeviceTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RootDeviceType]] = AwsError
      .unwrapOptionField("supportedRootDeviceTypes", supportedRootDeviceTypes)
    def getSupportedVirtualizationTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VirtualizationType]] =
      AwsError.unwrapOptionField(
        "supportedVirtualizationTypes",
        supportedVirtualizationTypes
      )
    def getBareMetal: ZIO[Any, AwsError, BareMetalFlag] =
      AwsError.unwrapOptionField("bareMetal", bareMetal)
    def getHypervisor
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceTypeHypervisor] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getProcessorInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.ProcessorInfo.ReadOnly] =
      AwsError.unwrapOptionField("processorInfo", processorInfo)
    def getVCpuInfo: ZIO[Any, AwsError, zio.aws.ec2.model.VCpuInfo.ReadOnly] =
      AwsError.unwrapOptionField("vCpuInfo", vCpuInfo)
    def getMemoryInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.MemoryInfo.ReadOnly] =
      AwsError.unwrapOptionField("memoryInfo", memoryInfo)
    def getInstanceStorageSupported: ZIO[Any, AwsError, InstanceStorageFlag] =
      AwsError.unwrapOptionField(
        "instanceStorageSupported",
        instanceStorageSupported
      )
    def getInstanceStorageInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStorageInfo.ReadOnly] =
      AwsError.unwrapOptionField("instanceStorageInfo", instanceStorageInfo)
    def getEbsInfo: ZIO[Any, AwsError, zio.aws.ec2.model.EbsInfo.ReadOnly] =
      AwsError.unwrapOptionField("ebsInfo", ebsInfo)
    def getNetworkInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInfo.ReadOnly] =
      AwsError.unwrapOptionField("networkInfo", networkInfo)
    def getGpuInfo: ZIO[Any, AwsError, zio.aws.ec2.model.GpuInfo.ReadOnly] =
      AwsError.unwrapOptionField("gpuInfo", gpuInfo)
    def getFpgaInfo: ZIO[Any, AwsError, zio.aws.ec2.model.FpgaInfo.ReadOnly] =
      AwsError.unwrapOptionField("fpgaInfo", fpgaInfo)
    def getPlacementGroupInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.PlacementGroupInfo.ReadOnly] =
      AwsError.unwrapOptionField("placementGroupInfo", placementGroupInfo)
    def getInferenceAcceleratorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceAcceleratorInfo",
      inferenceAcceleratorInfo
    )
    def getHibernationSupported: ZIO[Any, AwsError, HibernationFlag] =
      AwsError.unwrapOptionField("hibernationSupported", hibernationSupported)
    def getBurstablePerformanceSupported
        : ZIO[Any, AwsError, BurstablePerformanceFlag] =
      AwsError.unwrapOptionField(
        "burstablePerformanceSupported",
        burstablePerformanceSupported
      )
    def getDedicatedHostsSupported: ZIO[Any, AwsError, DedicatedHostFlag] =
      AwsError.unwrapOptionField(
        "dedicatedHostsSupported",
        dedicatedHostsSupported
      )
    def getAutoRecoverySupported: ZIO[Any, AwsError, AutoRecoveryFlag] =
      AwsError.unwrapOptionField("autoRecoverySupported", autoRecoverySupported)
    def getSupportedBootModes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.BootModeType]] =
      AwsError.unwrapOptionField("supportedBootModes", supportedBootModes)
    def getNitroEnclavesSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.NitroEnclavesSupport] =
      AwsError.unwrapOptionField("nitroEnclavesSupport", nitroEnclavesSupport)
    def getNitroTpmSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.NitroTpmSupport] =
      AwsError.unwrapOptionField("nitroTpmSupport", nitroTpmSupport)
    def getNitroTpmInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.NitroTpmInfo.ReadOnly] =
      AwsError.unwrapOptionField("nitroTpmInfo", nitroTpmInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
  ) extends zio.aws.ec2.model.InstanceTypeInfo.ReadOnly {
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val currentGeneration: Optional[CurrentGenerationFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentGeneration())
        .map(value => zio.aws.ec2.model.primitives.CurrentGenerationFlag(value))
    override val freeTierEligible: Optional[FreeTierEligibleFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.freeTierEligible())
        .map(value => zio.aws.ec2.model.primitives.FreeTierEligibleFlag(value))
    override val supportedUsageClasses
        : Optional[List[zio.aws.ec2.model.UsageClassType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedUsageClasses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.UsageClassType.wrap(item)
          }.toList
        )
    override val supportedRootDeviceTypes
        : Optional[List[zio.aws.ec2.model.RootDeviceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedRootDeviceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RootDeviceType.wrap(item)
          }.toList
        )
    override val supportedVirtualizationTypes
        : Optional[List[zio.aws.ec2.model.VirtualizationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedVirtualizationTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VirtualizationType.wrap(item)
          }.toList
        )
    override val bareMetal: Optional[BareMetalFlag] = zio.aws.core.internal
      .optionalFromNullable(impl.bareMetal())
      .map(value => zio.aws.ec2.model.primitives.BareMetalFlag(value))
    override val hypervisor
        : Optional[zio.aws.ec2.model.InstanceTypeHypervisor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hypervisor())
        .map(value => zio.aws.ec2.model.InstanceTypeHypervisor.wrap(value))
    override val processorInfo
        : Optional[zio.aws.ec2.model.ProcessorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorInfo())
        .map(value => zio.aws.ec2.model.ProcessorInfo.wrap(value))
    override val vCpuInfo: Optional[zio.aws.ec2.model.VCpuInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vCpuInfo())
        .map(value => zio.aws.ec2.model.VCpuInfo.wrap(value))
    override val memoryInfo: Optional[zio.aws.ec2.model.MemoryInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryInfo())
        .map(value => zio.aws.ec2.model.MemoryInfo.wrap(value))
    override val instanceStorageSupported: Optional[InstanceStorageFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStorageSupported())
        .map(value => zio.aws.ec2.model.primitives.InstanceStorageFlag(value))
    override val instanceStorageInfo
        : Optional[zio.aws.ec2.model.InstanceStorageInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStorageInfo())
        .map(value => zio.aws.ec2.model.InstanceStorageInfo.wrap(value))
    override val ebsInfo: Optional[zio.aws.ec2.model.EbsInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsInfo())
        .map(value => zio.aws.ec2.model.EbsInfo.wrap(value))
    override val networkInfo: Optional[zio.aws.ec2.model.NetworkInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInfo())
        .map(value => zio.aws.ec2.model.NetworkInfo.wrap(value))
    override val gpuInfo: Optional[zio.aws.ec2.model.GpuInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gpuInfo())
        .map(value => zio.aws.ec2.model.GpuInfo.wrap(value))
    override val fpgaInfo: Optional[zio.aws.ec2.model.FpgaInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fpgaInfo())
        .map(value => zio.aws.ec2.model.FpgaInfo.wrap(value))
    override val placementGroupInfo
        : Optional[zio.aws.ec2.model.PlacementGroupInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroupInfo())
        .map(value => zio.aws.ec2.model.PlacementGroupInfo.wrap(value))
    override val inferenceAcceleratorInfo
        : Optional[zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceAcceleratorInfo())
        .map(value => zio.aws.ec2.model.InferenceAcceleratorInfo.wrap(value))
    override val hibernationSupported: Optional[HibernationFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hibernationSupported())
        .map(value => zio.aws.ec2.model.primitives.HibernationFlag(value))
    override val burstablePerformanceSupported
        : Optional[BurstablePerformanceFlag] = zio.aws.core.internal
      .optionalFromNullable(impl.burstablePerformanceSupported())
      .map(value =>
        zio.aws.ec2.model.primitives.BurstablePerformanceFlag(value)
      )
    override val dedicatedHostsSupported: Optional[DedicatedHostFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedHostsSupported())
        .map(value => zio.aws.ec2.model.primitives.DedicatedHostFlag(value))
    override val autoRecoverySupported: Optional[AutoRecoveryFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRecoverySupported())
        .map(value => zio.aws.ec2.model.primitives.AutoRecoveryFlag(value))
    override val supportedBootModes
        : Optional[List[zio.aws.ec2.model.BootModeType]] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedBootModes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BootModeType.wrap(item)
        }.toList
      )
    override val nitroEnclavesSupport
        : Optional[zio.aws.ec2.model.NitroEnclavesSupport] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nitroEnclavesSupport())
        .map(value => zio.aws.ec2.model.NitroEnclavesSupport.wrap(value))
    override val nitroTpmSupport: Optional[zio.aws.ec2.model.NitroTpmSupport] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nitroTpmSupport())
        .map(value => zio.aws.ec2.model.NitroTpmSupport.wrap(value))
    override val nitroTpmInfo
        : Optional[zio.aws.ec2.model.NitroTpmInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nitroTpmInfo())
        .map(value => zio.aws.ec2.model.NitroTpmInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
  ): zio.aws.ec2.model.InstanceTypeInfo.ReadOnly = new Wrapper(impl)
}
