package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  InstanceEventWindowCronExpression,
  InstanceEventWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceEventWindow(
    instanceEventWindowId: Optional[InstanceEventWindowId] = Optional.Absent,
    timeRanges: Optional[
      Iterable[zio.aws.ec2.model.InstanceEventWindowTimeRange]
    ] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    cronExpression: Optional[InstanceEventWindowCronExpression] =
      Optional.Absent,
    associationTarget: Optional[
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget
    ] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.InstanceEventWindowState] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindow = {
    import InstanceEventWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindow
      .builder()
      .optionallyWith(
        instanceEventWindowId.map(value =>
          InstanceEventWindowId.unwrap(value): java.lang.String
        )
      )(_.instanceEventWindowId)
      .optionallyWith(
        timeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeRanges)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        cronExpression.map(value =>
          InstanceEventWindowCronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .optionallyWith(associationTarget.map(value => value.buildAwsValue()))(
        _.associationTarget
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceEventWindow.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindow.wrap(buildAwsValue())
}
object InstanceEventWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindow =
      zio.aws.ec2.model.InstanceEventWindow(
        instanceEventWindowId.map(value => value),
        timeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        cronExpression.map(value => value),
        associationTarget.map(value => value.asEditable),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceEventWindowId: Optional[InstanceEventWindowId]
    def timeRanges: Optional[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly]
    ]
    def name: Optional[String]
    def cronExpression: Optional[InstanceEventWindowCronExpression]
    def associationTarget: Optional[
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly
    ]
    def state: Optional[zio.aws.ec2.model.InstanceEventWindowState]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getInstanceEventWindowId: ZIO[Any, AwsError, InstanceEventWindowId] =
      AwsError.unwrapOptionField("instanceEventWindowId", instanceEventWindowId)
    def getTimeRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly
    ]] = AwsError.unwrapOptionField("timeRanges", timeRanges)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCronExpression
        : ZIO[Any, AwsError, InstanceEventWindowCronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
    def getAssociationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly
    ] = AwsError.unwrapOptionField("associationTarget", associationTarget)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceEventWindowState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindow
  ) extends zio.aws.ec2.model.InstanceEventWindow.ReadOnly {
    override val instanceEventWindowId: Optional[InstanceEventWindowId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceEventWindowId())
        .map(value => zio.aws.ec2.model.primitives.InstanceEventWindowId(value))
    override val timeRanges: Optional[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindowTimeRange.wrap(item)
        }.toList
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val cronExpression: Optional[InstanceEventWindowCronExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cronExpression())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression(value)
        )
    override val associationTarget: Optional[
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationTarget())
      .map(value =>
        zio.aws.ec2.model.InstanceEventWindowAssociationTarget.wrap(value)
      )
    override val state: Optional[zio.aws.ec2.model.InstanceEventWindowState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.InstanceEventWindowState.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindow
  ): zio.aws.ec2.model.InstanceEventWindow.ReadOnly = new Wrapper(impl)
}
