package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ImageBlockPublicAccessDisabledState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState
}
object ImageBlockPublicAccessDisabledState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState
  ): zio.aws.ec2.model.ImageBlockPublicAccessDisabledState = value match {
    case software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState.UNBLOCKED =>
      val r = unblocked
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ImageBlockPublicAccessDisabledState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState =
      software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState.UNKNOWN_TO_SDK_VERSION
  }
  case object unblocked
      extends zio.aws.ec2.model.ImageBlockPublicAccessDisabledState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState =
      software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessDisabledState.UNBLOCKED
  }
}
