package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.TotalFpgaMemory
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FpgaInfo(
    fpgas: Optional[Iterable[zio.aws.ec2.model.FpgaDeviceInfo]] =
      Optional.Absent,
    totalFpgaMemoryInMiB: Optional[TotalFpgaMemory] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FpgaInfo = {
    import FpgaInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaInfo
      .builder()
      .optionallyWith(
        fpgas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fpgas)
      .optionallyWith(
        totalFpgaMemoryInMiB.map(value =>
          TotalFpgaMemory.unwrap(value): Integer
        )
      )(_.totalFpgaMemoryInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaInfo.ReadOnly =
    zio.aws.ec2.model.FpgaInfo.wrap(buildAwsValue())
}
object FpgaInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FpgaInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaInfo = zio.aws.ec2.model.FpgaInfo(
      fpgas.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      totalFpgaMemoryInMiB.map(value => value)
    )
    def fpgas: Optional[List[zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly]]
    def totalFpgaMemoryInMiB: Optional[TotalFpgaMemory]
    def getFpgas
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly]] =
      AwsError.unwrapOptionField("fpgas", fpgas)
    def getTotalFpgaMemoryInMiB: ZIO[Any, AwsError, TotalFpgaMemory] =
      AwsError.unwrapOptionField("totalFpgaMemoryInMiB", totalFpgaMemoryInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaInfo
  ) extends zio.aws.ec2.model.FpgaInfo.ReadOnly {
    override val fpgas
        : Optional[List[zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fpgas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FpgaDeviceInfo.wrap(item)
          }.toList
        )
    override val totalFpgaMemoryInMiB: Optional[TotalFpgaMemory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalFpgaMemoryInMiB())
        .map(value => zio.aws.ec2.model.primitives.TotalFpgaMemory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaInfo
  ): zio.aws.ec2.model.FpgaInfo.ReadOnly = new Wrapper(impl)
}
