package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  SubnetId,
  VpcId,
  SecurityGroupId,
  InstanceConnectEndpointId,
  MillisecondDateTime,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class Ec2InstanceConnectEndpoint(
    ownerId: Optional[String] = Optional.Absent,
    instanceConnectEndpointId: Optional[InstanceConnectEndpointId] =
      Optional.Absent,
    instanceConnectEndpointArn: Optional[ResourceArn] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpointState] =
      Optional.Absent,
    stateMessage: Optional[String] = Optional.Absent,
    dnsName: Optional[String] = Optional.Absent,
    fipsDnsName: Optional[String] = Optional.Absent,
    networkInterfaceIds: Optional[Iterable[String]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    createdAt: Optional[MillisecondDateTime] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    preserveClientIp: Optional[Boolean] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint = {
    import Ec2InstanceConnectEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        instanceConnectEndpointId.map(value =>
          InstanceConnectEndpointId.unwrap(value): java.lang.String
        )
      )(_.instanceConnectEndpointId)
      .optionallyWith(
        instanceConnectEndpointArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.instanceConnectEndpointArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .optionallyWith(fipsDnsName.map(value => value: java.lang.String))(
        _.fipsDnsName
      )
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        createdAt.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(preserveClientIp.map(value => value: java.lang.Boolean))(
        _.preserveClientIp
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly =
    zio.aws.ec2.model.Ec2InstanceConnectEndpoint.wrap(buildAwsValue())
}
object Ec2InstanceConnectEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ec2InstanceConnectEndpoint =
      zio.aws.ec2.model.Ec2InstanceConnectEndpoint(
        ownerId.map(value => value),
        instanceConnectEndpointId.map(value => value),
        instanceConnectEndpointArn.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        dnsName.map(value => value),
        fipsDnsName.map(value => value),
        networkInterfaceIds.map(value => value),
        vpcId.map(value => value),
        availabilityZone.map(value => value),
        createdAt.map(value => value),
        subnetId.map(value => value),
        preserveClientIp.map(value => value),
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ownerId: Optional[String]
    def instanceConnectEndpointId: Optional[InstanceConnectEndpointId]
    def instanceConnectEndpointArn: Optional[ResourceArn]
    def state: Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpointState]
    def stateMessage: Optional[String]
    def dnsName: Optional[String]
    def fipsDnsName: Optional[String]
    def networkInterfaceIds: Optional[List[String]]
    def vpcId: Optional[VpcId]
    def availabilityZone: Optional[String]
    def createdAt: Optional[MillisecondDateTime]
    def subnetId: Optional[SubnetId]
    def preserveClientIp: Optional[Boolean]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getInstanceConnectEndpointId
        : ZIO[Any, AwsError, InstanceConnectEndpointId] = AwsError
      .unwrapOptionField("instanceConnectEndpointId", instanceConnectEndpointId)
    def getInstanceConnectEndpointArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "instanceConnectEndpointArn",
        instanceConnectEndpointArn
      )
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.Ec2InstanceConnectEndpointState
    ] = AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getFipsDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fipsDnsName", fipsDnsName)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreatedAt: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getPreserveClientIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("preserveClientIp", preserveClientIp)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint
  ) extends zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val instanceConnectEndpointId
        : Optional[InstanceConnectEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceConnectEndpointId())
      .map(value =>
        zio.aws.ec2.model.primitives.InstanceConnectEndpointId(value)
      )
    override val instanceConnectEndpointArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConnectEndpointArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val state
        : Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpointState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.Ec2InstanceConnectEndpointState.wrap(value)
        )
    override val stateMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMessage())
      .map(value => value: String)
    override val dnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => value: String)
    override val fipsDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fipsDnsName())
      .map(value => value: String)
    override val networkInterfaceIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val createdAt: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val preserveClientIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.preserveClientIp())
      .map(value => value: Boolean)
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint
  ): zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly = new Wrapper(impl)
}
