package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableIpamOrganizationAdminAccountRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    delegatedAdminAccountId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest = {
    import DisableIpamOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .delegatedAdminAccountId(delegatedAdminAccountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object DisableIpamOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest =
      zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest(
        dryRun.map(value => value),
        delegatedAdminAccountId
      )
    def dryRun: Optional[Boolean]
    def delegatedAdminAccountId: String
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getDelegatedAdminAccountId: ZIO[Any, Nothing, String] =
      ZIO.succeed(delegatedAdminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest
  ) extends zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val delegatedAdminAccountId: String =
      impl.delegatedAdminAccountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest
  ): zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
