package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableImageBlockPublicAccessResponse(
    imageBlockPublicAccessState: Optional[
      zio.aws.ec2.model.ImageBlockPublicAccessDisabledState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse = {
    import DisableImageBlockPublicAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse
      .builder()
      .optionallyWith(imageBlockPublicAccessState.map(value => value.unwrap))(
        _.imageBlockPublicAccessState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableImageBlockPublicAccessResponse.ReadOnly =
    zio.aws.ec2.model.DisableImageBlockPublicAccessResponse
      .wrap(buildAwsValue())
}
object DisableImageBlockPublicAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableImageBlockPublicAccessResponse =
      zio.aws.ec2.model.DisableImageBlockPublicAccessResponse(
        imageBlockPublicAccessState.map(value => value)
      )
    def imageBlockPublicAccessState
        : Optional[zio.aws.ec2.model.ImageBlockPublicAccessDisabledState]
    def getImageBlockPublicAccessState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImageBlockPublicAccessDisabledState
    ] = AwsError.unwrapOptionField(
      "imageBlockPublicAccessState",
      imageBlockPublicAccessState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse
  ) extends zio.aws.ec2.model.DisableImageBlockPublicAccessResponse.ReadOnly {
    override val imageBlockPublicAccessState
        : Optional[zio.aws.ec2.model.ImageBlockPublicAccessDisabledState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBlockPublicAccessState())
        .map(value =>
          zio.aws.ec2.model.ImageBlockPublicAccessDisabledState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse
  ): zio.aws.ec2.model.DisableImageBlockPublicAccessResponse.ReadOnly =
    new Wrapper(impl)
}
